/**
 * 
 */
package gov.va.med.mhv.usermgmt.test.builder;

import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.va.med.mhv.core.util.DescriptionBuilder;
import gov.va.med.mhv.usermgmt.enumeration.BloodTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.ContactMethodEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.CountryEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.GenderEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.MaritalStatusEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.PasswordHintQuestionEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.StateEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.TitleEnumeration;
import gov.va.med.mhv.usermgmt.transfer.TransferObjectFactory;
import gov.va.med.mhv.usermgmt.transfer.UserProfile;

/**
 * @author Rob Proper (Aquilent Inc.)
 *
 */
public class UserReader {
    
    private static final Log LOG = LogFactory.getLog(UserReader.class);

    private static final String USER_PREFIX = "user";
    private static final String USER_NAME = "userName";
    private static final String PASSWORD = "password";
    private static final String FIRST_NAME = "firstName";
    private static final String LAST_NAME = "lastName";
    private static final String DOB = "dob";
    private static final String SSN = "ssn";
    private static final String IS_PATIENT = "isPatient";
    private static final String IPA_PATIENT = "ipaPatient";
    private static final String GENDER = "gender";
    private static final String TITLE = "title";
    private static final String BLOODTYPE = "bloodType";
    
    private List<User> users = new ArrayList<User>();
    
    public UserReader(Class clazz, String name) throws IOException {
        this(clazz.getResource(name).toString());
    }
    
    public UserReader(String url) throws IOException {
        Properties properties = new Properties();
        URL urlX = new URL(url);
        properties.load(urlX.openStream());
        for (int i = 0; readUsers(properties,i); i++){
            if (LOG.isInfoEnabled()) {
                LOG.info("Read user " + users.get(users.size()-1).
                    getUserProfile().getUserName());
            }
        }
    }
    
    public List<User> getUsers() {
        return Collections.unmodifiableList(users);
    }

    private boolean readUsers(Properties properties, int index) {
        final String prefix = USER_PREFIX + "[" + index + "].";
        if (!properties.containsKey(createKey(prefix, USER_NAME))) {
            return false;
        }
        users.add(new User(readUserProfile(properties, prefix), 
            getProperty(properties, prefix, PASSWORD, "Tester1&"), 
            getBooleanProperty(properties, prefix, IPA_PATIENT, false)));
        return true;
    }
    
    private UserProfile readUserProfile(Properties properties, String prefix) {
        UserProfile userProfile = TransferObjectFactory.createUserProfile();
        userProfile.setUserName(getProperty(properties, prefix, USER_NAME));
        userProfile.setFirstName(getProperty(properties, prefix, FIRST_NAME));
        userProfile.setLastName(getProperty(properties, prefix, LAST_NAME));
        userProfile.setBirthDate(getDateProperty(properties, prefix, DOB));
        userProfile.setSsn(getProperty(properties, prefix, SSN));
        userProfile.setIsPatient(getBooleanProperty(properties, prefix, 
            IS_PATIENT, false));
        userProfile.setGender(getGenderProperty(properties, prefix));
        userProfile.setTitle(getTitleProperty(properties, prefix));
        userProfile.setBloodType(getBloodTypeProperty(properties, prefix));
        userProfile.setIsOrganDonor(Boolean.TRUE);
        userProfile.setMaritalStatus(MaritalStatusEnumeration.getEnum(
            MaritalStatusEnumeration.DIVORCED));
        userProfile.setIsVeteran(Boolean.TRUE);
        userProfile.setAddressStreet1("1 Some Street");
        userProfile.setAddressCity("Nowhere Town");
        userProfile.setAddressState(StateEnumeration.getEnum(StateEnumeration.VA));
        userProfile.setAddressPostalCode("12345");
        userProfile.setAddressCountry(CountryEnumeration.getEnum(
            CountryEnumeration.UNITED_STATES));
        userProfile.setContactInfoContactMethod(ContactMethodEnumeration.getEnum(
            ContactMethodEnumeration.HOMEPHONE));
        userProfile.setContactInfoHomePhone("111-111-1111");
        userProfile.setContactInfoEmail("dummyserv.domain.ext");
        userProfile.setPasswordHintQuestion1(PasswordHintQuestionEnumeration.
            getEnum(PasswordHintQuestionEnumeration.FAVORITEFOOD));
        userProfile.setPasswordHintAnswer1("Pizza");
        userProfile.setPasswordHintQuestion2(PasswordHintQuestionEnumeration.
            getEnum(PasswordHintQuestionEnumeration.PETNAME));
        userProfile.setPasswordHintAnswer2("Spot");
        userProfile.setAcceptDisclaimer(Boolean.TRUE);
        userProfile.setAcceptPrivacy(Boolean.TRUE);
        userProfile.setAcceptTerms(Boolean.TRUE);
        return userProfile;
    }

    private static final String createKey(String prefix, String key) {
        return prefix + key;
    }
    private static final String getProperty(Properties properties, 
        String prefix, String key) 
    {
        String value = properties.getProperty(createKey(prefix,key));
        if (LOG.isDebugEnabled()) {
            LOG.debug(createKey(prefix, key) + "=[" + value + "]");
        }
        return value;
    }
    private static final String getProperty(Properties properties, 
        String prefix, String key, String defaultValue) 
    {
        String value = properties.getProperty(createKey(prefix,key));
        if (LOG.isDebugEnabled()) {
            LOG.debug(createKey(prefix, key) + "=[" + value +
                ((value != null) ? "" : "] using default [" + defaultValue) +
                "]");
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }
    
    
    private static final Boolean getBooleanProperty(Properties properties, 
        String prefix, String key, boolean defaultValue)
    {
        String value = getProperty(properties, prefix, key, Boolean.toString(
            defaultValue));
        return (value != null) ? Boolean.parseBoolean(value) : null;
    }

    private static final Date getDateProperty(Properties properties, 
        String prefix, String key)
    {
        final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy"); 
        String value = getProperty(properties, prefix, key);
        try {
            return (value != null) ? DATE_FORMAT.parse(value) : null;
        } catch (ParseException e) {
            LOG.error("Unable to parse " + createKey(prefix, key) +
                "to a date", e);
            return null;
        }
    }

    private static final GenderEnumeration getGenderProperty(
        Properties properties, String prefix)
    {
        String key = GENDER;
        GenderEnumeration gender = GenderEnumeration.getEnum(getProperty(
            properties, prefix, key, GenderEnumeration.MALE));
        if (gender == null) {
            LOG.error(createKey(prefix, key) 
                + " is not a gender value. Expected one of "
                + DescriptionBuilder.describe(GenderEnumeration.getEnumMap().
                    keySet()));
        }
        return gender;
    }

    private static final TitleEnumeration getTitleProperty(
        Properties properties, String prefix)
    {
        String key = TITLE;
        TitleEnumeration title = TitleEnumeration.getEnum(getProperty(
            properties, prefix, key, TitleEnumeration.MR));
        if (title == null) {
            LOG.error(createKey(prefix, key) 
                + " is not a title value. Expected one of "
                + DescriptionBuilder.describe(TitleEnumeration.getEnumMap().
                    keySet()));
        }
        return title;
    }
    
    private static final BloodTypeEnumeration getBloodTypeProperty(
        Properties properties, String prefix)
    {
        String key = BLOODTYPE;
        BloodTypeEnumeration title = BloodTypeEnumeration.getEnum(getProperty(
            properties, prefix, key, BloodTypeEnumeration.O_NEGATIVE));
        if (title == null) {
            LOG.error(createKey(prefix, key) 
                + " is not a blood_type value. Expected one of "
                + DescriptionBuilder.describe(BloodTypeEnumeration.getEnumMap().
                    keySet()));
        }
        return title;
    }
    
}
